@extends('upgrade.layout')

@section('title', 'Upgrade')
@section('subtitle', 'Upgrading your application')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Upgrade In Progress</h2>
    
    <p style="margin-bottom: var(--spacing-xl);">
        Please wait while we upgrade your application. This may take several minutes.
    </p>
    
    <div id="upgradeProgress">
        <div style="text-align: center; margin-bottom: var(--spacing-xl);">
            <div class="loader" style="width: 48px; height: 48px; border-width: 4px; margin: 0 auto var(--spacing-lg);"></div>
            <h3 style="margin-top: var(--spacing-md); color: var(--white);">Upgrading...</h3>
            <p id="progressText" style="margin-top: var(--spacing-sm); color: var(--light-gray);">Preparing upgrade process...</p>
        </div>
        
        <div style="background-color: var(--dark-gray); border-radius: var(--border-radius-md); overflow: hidden; height: 16px; margin-bottom: var(--spacing-md);">
            <div id="progressBar" style="width: 0%; height: 100%; background: linear-gradient(90deg, var(--primary-color), var(--primary-light)); transition: width 0.5s ease;"></div>
        </div>
        
        <div style="text-align: center; color: var(--light-gray); font-size: 0.9rem;">
            <span id="progressPercent">0</span>% Complete
        </div>
    </div>
    
    <div id="upgradeComplete" style="display: none;">
        <div class="completion-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        
        <h3 style="text-align: center; color: var(--white); margin-bottom: var(--spacing-lg);">
            Upgrade Completed Successfully!
        </h3>
        
        <div style="text-align: center;">
            <a href="{{ route('upgrade.complete') }}" class="btn btn-success">
                <i class="fas fa-check"></i> Finish
            </a>
        </div>
    </div>
    
    <div id="upgradeError" style="display: none;">
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <div>
                <strong>Upgrade Failed</strong>
                <p id="errorMessage" style="margin-top: var(--spacing-xs);"></p>
            </div>
        </div>
        
        <div style="text-align: center; margin-top: var(--spacing-lg); display: flex; gap: var(--spacing-md); justify-content: center;">
            <a href="{{ route('upgrade.rollback') }}" class="btn btn-warning">
                <i class="fas fa-undo"></i> Rollback
            </a>
            <a href="{{ route('upgrade.index') }}" class="btn">
                <i class="fas fa-home"></i> Go Back
            </a>
        </div>
    </div>
    
    <div style="margin-top: var(--spacing-xxl); background-color: rgba(255, 193, 7, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-md); border: 1px solid rgba(255, 193, 7, 0.2);">
        <div style="display: flex; align-items: flex-start;">
            <i class="fas fa-exclamation-triangle" style="color: var(--warning); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
            <p style="font-size: 0.9rem; margin: 0;">
                <strong>Please do not close this window or refresh the page.</strong> The upgrade process is running and interrupting it could cause issues with your application.
            </p>
        </div>
    </div>
@endsection

@section('footer')
    <div></div>
    <div></div>
@endsection

@section('scripts')
<script>
    let upgradeStarted = false;
    let pollInterval;
    
    function startUpgrade() {
        if (upgradeStarted) return;
        upgradeStarted = true;
        
        fetch('{{ route('upgrade.do_upgrade') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            clearInterval(pollInterval);
            
            if (data.success) {
                document.getElementById('upgradeProgress').style.display = 'none';
                document.getElementById('upgradeComplete').style.display = 'block';
            } else {
                document.getElementById('upgradeProgress').style.display = 'none';
                document.getElementById('upgradeError').style.display = 'block';
                document.getElementById('errorMessage').textContent = data.message;
            }
        })
        .catch(error => {
            clearInterval(pollInterval);
            document.getElementById('upgradeProgress').style.display = 'none';
            document.getElementById('upgradeError').style.display = 'block';
            document.getElementById('errorMessage').textContent = 'An unexpected error occurred: ' + error.message;
        });
    }
    
    function pollProgress() {
        fetch('{{ route('upgrade.progress') }}')
            .then(response => response.json())
            .then(data => {
                const percent = data.percent || 0;
                const message = data.message || 'Processing...';
                
                document.getElementById('progressBar').style.width = percent + '%';
                document.getElementById('progressPercent').textContent = percent;
                document.getElementById('progressText').textContent = message;
            })
            .catch(error => {
                console.error('Failed to fetch progress:', error);
            });
    }
    
    // Start upgrade when page loads
    window.addEventListener('load', function() {
        // Poll progress every second
        pollInterval = setInterval(pollProgress, 1000);
        
        // Start upgrade after a short delay
        setTimeout(startUpgrade, 500);
    });
</script>
@endsection